//
//  HighPriorityButtonStyle.swift
//  Do It
//
//  Created by Jim Dovey on 1/28/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

// START:ButtonStyleDecl
struct HighPriorityButtonStyle: PrimitiveButtonStyle {
    // END:ButtonStyleDecl
    // START:MakeBody
    func makeBody(configuration: PrimitiveButtonStyle.Configuration) -> some View {
        _Button(configuration: configuration)
    }
    // END:MakeBody

    // START:InnerButtonView
    private struct _Button: View {
        @State var pressed = false
        let configuration: PrimitiveButtonStyle.Configuration
        
        var body: some View {
            // <literal:elide> ... </literal:elide>
            // END:InnerButtonView
            // START:InnerButtonBody
            // START:GestureMap
            let gesture = DragGesture(minimumDistance: 0)
                .map { self.translation($0.translation, doesNotExceed: 15) }
            // END:GestureMap
            // START:GestureChanged
                .onChanged { value in self.pressed = value }
            // END:GestureChanged
            // START:GestureEnded
                .onEnded { value in
                    guard self.pressed else { return }
                    self.pressed = false
                    self.configuration.trigger()
                }
            // END:GestureEnded

            // START_HIGHLIGHT
            return configuration.label
                .opacity(pressed ? 0.5 : 1.0)
                .highPriorityGesture(gesture)
            // END_HIGHLIGHT
            // END:InnerButtonBody
        }

        // START:TranslationCheck
        private func translation(_ translation: CGSize, doesNotExceed: CGFloat) -> Bool {
            let max = abs(doesNotExceed)
            return translation.width < max && translation.width > -max &&
                translation.height < max && translation.height > -max
            // START:InnerButtonView
        }
        // END:TranslationCheck
    }
    // END:InnerButtonView
    // START:ButtonStyleDecl
}
// END:ButtonStyleDecl

struct HighPriorityButtonStyle_Previews: PreviewProvider {
    // START:Preview
    static var previews: some View {
        NavigationView {
            List {
                NavigationLink(destination: Text("Hello")) {
                    Button(action: { print("hello") }) {
                        Text("Button!")
                            .foregroundColor(.accentColor)
                    }
                    .buttonStyle(HighPriorityButtonStyle())
                }
            }
        }
    }
    // END:Preview
}
